function [peak1_indiv_cell_exp, peak2_indiv_cell_exp, peak2_extr_indiv_cell_exp, ppr_indiv_cell_exp, ppr_extr_indiv_cell_exp] = call_data_analysis_paper(plot_on_off, show_plot_on_off, disp_on_off)



if ~ (exist('./Exp_data', 'dir'))
    error('You are not in the appropriate folder')
end



cell_nums = {'0802', '1700', '1705', '2307', '2302', '2201'};

num_cells = length(cell_nums);
num_sweeps = 10;
num_calc = 5;

total_number = num_cells * num_sweeps * num_calc;

start_numbers = [0 3 1 1 0 0];

peak1_indiv_cell_exp = zeros(num_cells, num_sweeps, num_calc);
peak2_indiv_cell_exp = zeros(num_cells, num_sweeps, num_calc);
peak2_extr_indiv_cell_exp = zeros(num_cells, num_sweeps, num_calc);
peak_covariances_indiv_cells = zeros(num_cells, num_calc);

stim1_begins = zeros(num_calc, num_cells*num_sweeps);


for k = 1:num_calc*num_cells
    n = ceil(k/num_calc);
    cell_n = cell_nums{n};
    ca_n = mod(k-1,5) + 1;
    ca_ind = start_numbers(n) + ca_n - 1;
    filename = ['17n' cell_n num2str(ca_ind) '.abf'];

    [peak1s, peak2s, peak2_extrs, time_vec, EPSCs_trans, stim1_begs] = data_analyze_abf(filename, total_number, k, plot_on_off, show_plot_on_off, disp_on_off);
    

    peak1_indiv_cell_exp(n, :, ca_n) = peak1s';
    peak2_indiv_cell_exp(n, :, ca_n) = peak2s';
    peak2_extr_indiv_cell_exp(n, :, ca_n) = peak2_extrs';
    
    
    
    
    
    if k == 1
        EPSCs_all = zeros(num_calc, num_cells*num_sweeps, length(time_vec));
    end
        
    EPSCs_all(ca_n, ((n-1)*10+1):n*10, :) = EPSCs_trans';
    stim1_begins(ca_n, ((n-1)*10+1):n*10) = stim1_begs;
    
end


%%%%Test whether horisontal alignment is necessary
test_stim = stim1_begins(:) - stim1_begins(1,1,1);
test_stim_res = sum(test_stim);

if test_stim_res~= 0
    error('Operation terminated prematurely: EPSCs need horisontal alignment')    
end



EPSC_ave = squeeze(mean(EPSCs_all, 2));



ppr_indiv_cell_exp = peak2_indiv_cell_exp ./ peak1_indiv_cell_exp;
ppr_extr_indiv_cell_exp = peak2_extr_indiv_cell_exp ./ peak1_indiv_cell_exp;



%%%Means and variances exclude the first experiment

aver_index = 2:10;
peak1_excl_first_exp = peak1_indiv_cell_exp(:,aver_index,:);
peak2_excl_first_exp = peak2_indiv_cell_exp(:,aver_index,:);
peak2_extr_excl_first_exp = peak2_extr_indiv_cell_exp(:,aver_index,:);
peaksum_extr_excl_first_exp = peak1_excl_first_exp + peak2_extr_excl_first_exp;
ppr_excl_first_exp = ppr_indiv_cell_exp(:,aver_index,:);
ppr_extr_excl_first_exp = ppr_extr_indiv_cell_exp(:,aver_index,:);


%%Calculate covariance

for m = 1:num_cells
    for n = 1:num_calc
        peak1s_for_cov = squeeze(peak1_excl_first_exp(m,:,n));
        peak2s_for_cov = squeeze(peak2_extr_excl_first_exp(m,:,n));
        cov_matrix = cov(peak1s_for_cov, peak2s_for_cov);
        peak_covariances_indiv_cells(m,n) = cov_matrix(1,2);
    end
end




peak1_means_indiv_cells_exp = squeeze(mean(peak1_excl_first_exp, 2));
peak1_medians_indiv_cells_exp = squeeze(median(peak1_excl_first_exp, 2));
peak1_vars_indiv_cells_exp = squeeze(var(peak1_excl_first_exp, 0, 2));
peak1_stds_indiv_cells_exp = squeeze(std(peak1_excl_first_exp, 0, 2));
peak1_excl_rearrange_exp = reshape(peak1_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
peak1_mean_all_cells_exp = mean(peak1_excl_rearrange_exp,1);
peak1_median_all_cells_exp = median(peak1_excl_rearrange_exp,1);
peak1_var_all_cells_exp = var(peak1_excl_rearrange_exp,0);
peak1_std_all_cells_exp = std(peak1_excl_rearrange_exp,0);
peak1_means_of_vars_exp = mean(peak1_vars_indiv_cells_exp);
peak1_sqrt_of_vars_exp = sqrt(peak1_means_of_vars_exp);

peak1_var_of_means_exp = var(peak1_means_indiv_cells_exp,0);
peak1_std_of_means_exp = std(peak1_means_indiv_cells_exp,0);


peak2_means_indiv_cells_exp = squeeze(mean(peak2_excl_first_exp, 2));
peak2_medians_indiv_cells_exp = squeeze(median(peak2_excl_first_exp, 2));
peak2_vars_indiv_cells_exp = squeeze(var(peak2_excl_first_exp, 0, 2));
peak2_stds_indiv_cells_exp = squeeze(std(peak2_excl_first_exp, 0, 2));
peak2_excl_rearrange_exp = reshape(peak2_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
peak2_extr_excl_rearrange_exp = reshape(peak2_extr_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
peak2_mean_all_cells_exp = mean(peak2_excl_rearrange_exp,1);
peak2_median_all_cells_exp = median(peak2_excl_rearrange_exp,1);
peak2_var_all_cells_exp = var(peak2_excl_rearrange_exp,0);
peak2_std_all_cells_exp = std(peak2_excl_rearrange_exp,0);
peak2_means_of_vars_exp = mean(peak2_vars_indiv_cells_exp);
peak2_extr_mean_all_cells_exp = mean(peak2_extr_excl_rearrange_exp,1);
peak2_extr_median_all_cells_exp = median(peak2_extr_excl_rearrange_exp,1);
peak2_extr_var_all_cells_exp = var(peak2_extr_excl_rearrange_exp,0);
peak2_extr_std_all_cells_exp = std(peak2_extr_excl_rearrange_exp,0);
peak2_std_of_means_exp = std(peak2_means_indiv_cells_exp,0);
peak2_var_of_means_exp = var(peak2_means_indiv_cells_exp,0);
peak2_sqrt_of_vars_exp = sqrt(peak2_means_of_vars_exp);

peak2_extr_vars_indiv_cells_exp = squeeze(var(peak2_extr_excl_first_exp, 0, 2));
peak2_extr_stds_indiv_cells_exp = squeeze(std(peak2_extr_excl_first_exp, 0, 2));
peak2_extr_means_of_vars_exp = mean(peak2_extr_vars_indiv_cells_exp);
peak2_extr_sqrt_of_vars_exp = sqrt(peak2_extr_means_of_vars_exp);

peaksum_extr_means_indiv_cells_exp = squeeze(mean(peaksum_extr_excl_first_exp, 2));
peaksum_extr_vars_indiv_cells_exp = squeeze(var(peaksum_extr_excl_first_exp, 0, 2));
peaksum_extr_excl_rearrange_exp = reshape(peaksum_extr_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
peaksum_extr_mean_all_cells_exp = mean(peaksum_extr_excl_rearrange_exp,1);
peaksum_extr_means_of_vars_exp = mean(peaksum_extr_vars_indiv_cells_exp);



ppr_means_indiv_cells_exp = squeeze(mean(ppr_excl_first_exp, 2));
ppr_medians_indiv_cells_exp = squeeze(median(ppr_excl_first_exp, 2));
ppr_extr_means_indiv_cells_exp = squeeze(mean(ppr_extr_excl_first_exp, 2));
ppr_vars_indiv_cells_exp = squeeze(var(ppr_excl_first_exp, 0, 2));
ppr_stds_indiv_cells_exp = squeeze(std(ppr_excl_first_exp, 0, 2));
ppr_excl_rearrange_exp = reshape(ppr_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
ppr_extr_excl_rearrange_exp = reshape(ppr_extr_excl_first_exp(:), num_cells*length(aver_index), num_calc); 
ppr_mean_all_cells_exp = mean(ppr_excl_rearrange_exp,1);
ppr_median_all_cells_exp = median(ppr_excl_rearrange_exp,1);
ppr_var_all_cells_exp = var(ppr_excl_rearrange_exp,0);
ppr_std_all_cells_exp = std(ppr_excl_rearrange_exp,0);
ppr_means_of_vars_exp = mean(ppr_vars_indiv_cells_exp);
ppr_extr_mean_all_cells_exp = mean(ppr_extr_excl_rearrange_exp,1);
ppr_extr_median_all_cells_exp = median(ppr_extr_excl_rearrange_exp,1);
ppr_extr_var_all_cells_exp = var(ppr_extr_excl_rearrange_exp,0);
ppr_extr_std_all_cells_exp = std(ppr_extr_excl_rearrange_exp,0);
ppr_std_of_means_exp = std(ppr_means_indiv_cells_exp,0);
ppr_var_of_means_exp = var(ppr_means_indiv_cells_exp,0);
ppr_extr_std_of_means_exp = std(ppr_extr_means_indiv_cells_exp,0);
ppr_extr_var_of_means_exp = var(ppr_extr_means_indiv_cells_exp,0);
ppr_extr_stds_indiv_cells_exp = squeeze(std(ppr_extr_excl_first_exp, 0, 2));
ppr_extr_vars_indiv_cells_exp = squeeze(var(ppr_extr_excl_first_exp, 0, 2));

ppr_extr_means_of_vars_exp = mean(ppr_extr_vars_indiv_cells_exp);
ppr_extr_sqrt_of_vars_exp = sqrt(ppr_extr_means_of_vars_exp);

% save('EPSCs_indiv_exp', 'EPSCs_indiv_exp', 'EPSC_mean_exp')


save('./Exp_data/Data_IndivCells_extr', ... 
'peak1_indiv_cell_exp', ...
'peak1_excl_first_exp', ...
'peak2_excl_first_exp', ...
'peak2_extr_excl_first_exp', ...
'ppr_excl_first_exp', ...
'ppr_extr_excl_first_exp', ...
'peak2_indiv_cell_exp', ...
'peak2_extr_indiv_cell_exp', ...
'ppr_indiv_cell_exp', ...
'ppr_extr_indiv_cell_exp', ...
'peak1_means_indiv_cells_exp', ...
'peak1_medians_indiv_cells_exp', ...
'peak1_vars_indiv_cells_exp', ...
'peak1_stds_indiv_cells_exp', ...
'peak1_mean_all_cells_exp', ...
'peak1_var_all_cells_exp', ...
'peak1_std_all_cells_exp', ...
'peak1_means_of_vars_exp', ...
'ppr_means_indiv_cells_exp', ...
'ppr_medians_indiv_cells_exp', ...
'ppr_vars_indiv_cells_exp', ...
'ppr_stds_indiv_cells_exp', ...
'ppr_mean_all_cells_exp', ...
'ppr_var_all_cells_exp', ...
'ppr_std_all_cells_exp', ...
'ppr_means_of_vars_exp', ...
'peak1_median_all_cells_exp', ...
'ppr_median_all_cells_exp', ...
'peak2_means_indiv_cells_exp', ...
'peak2_medians_indiv_cells_exp', ...
'peak2_vars_indiv_cells_exp', ...
'peak2_stds_indiv_cells_exp', ...
'peak2_mean_all_cells_exp', ...
'peak2_median_all_cells_exp', ...
'peak2_var_all_cells_exp', ...
'peak2_std_all_cells_exp', ...
'peak2_means_of_vars_exp', ...
'peak2_extr_mean_all_cells_exp', ...
'peak2_extr_median_all_cells_exp', ...
'peak2_extr_std_all_cells_exp', ...
'ppr_extr_mean_all_cells_exp', ...
'ppr_extr_var_all_cells_exp', ...
'ppr_extr_std_all_cells_exp', ...
'peak2_extr_var_all_cells_exp', ...
'peak1_std_of_means_exp', ...
'peak2_std_of_means_exp', ...
'ppr_std_of_means_exp', ...
'peak1_var_of_means_exp', ...
'peak2_var_of_means_exp', ...
'ppr_var_of_means_exp', ...
'ppr_extr_std_of_means_exp', ...
'ppr_extr_var_of_means_exp', ...
'ppr_extr_means_indiv_cells_exp', ...
'peak_covariances_indiv_cells', ...
'peak1_sqrt_of_vars_exp', ...
'peak2_sqrt_of_vars_exp', ...
'ppr_extr_sqrt_of_vars_exp', ...
'ppr_extr_means_of_vars_exp',... 
'peak2_extr_vars_indiv_cells_exp', ...
'peak2_extr_stds_indiv_cells_exp', ...
'peak2_extr_means_of_vars_exp', ...
'peaksum_extr_mean_all_cells_exp', ...
'peaksum_extr_means_of_vars_exp', ...
'peak2_extr_sqrt_of_vars_exp');








save('./Exp_data/DataSummary_extr', ... 
'peak1_mean_all_cells_exp', ...
'peak1_var_all_cells_exp', ...
'peak1_std_all_cells_exp', ...
'peak1_means_of_vars_exp', ...
'ppr_mean_all_cells_exp', ...
'ppr_var_all_cells_exp', ...
'ppr_std_all_cells_exp', ...
'ppr_means_of_vars_exp', ...
'peak2_mean_all_cells_exp', ...
'peak2_var_all_cells_exp', ...
'peak2_std_all_cells_exp', ...
'peak2_means_of_vars_exp', ...
'peak2_extr_mean_all_cells_exp', ...
'peak2_extr_std_all_cells_exp', ...
'ppr_extr_mean_all_cells_exp', ...
'ppr_extr_var_all_cells_exp', ...
'ppr_extr_std_all_cells_exp', ...
'peak2_extr_var_all_cells_exp', ...
'peak1_std_of_means_exp', ...
'peak2_std_of_means_exp', ...
'ppr_std_of_means_exp', ...
'peak1_var_of_means_exp', ...
'peak2_var_of_means_exp', ...
'ppr_var_of_means_exp', ...
'ppr_extr_std_of_means_exp', ...
'ppr_extr_var_of_means_exp', ...
'peak_covariances_indiv_cells', ...
'ppr_extr_sqrt_of_vars_exp', ...
'ppr_extr_means_of_vars_exp',... 
'peak2_extr_vars_indiv_cells_exp', ...
'peak2_extr_stds_indiv_cells_exp', ...
'peak2_extr_means_of_vars_exp', ...
'peak2_extr_sqrt_of_vars_exp', ...
'peak2_sqrt_of_vars_exp', ...
'peaksum_extr_mean_all_cells_exp', ...
'peaksum_extr_means_of_vars_exp', ...
'peak1_sqrt_of_vars_exp');

save('./Exp_data/DataOnlyMeans_extr', ... 
'peak1_mean_all_cells_exp', ...
'ppr_mean_all_cells_exp', ...
'peak2_mean_all_cells_exp', ...
'peak2_extr_mean_all_cells_exp', ...
'ppr_extr_mean_all_cells_exp', ...
'peaksum_extr_mean_all_cells_exp', ...
'peak_covariances_indiv_cells');



save('./Exp_data/EPSC_ave_exp.mat', 'time_vec', 'EPSC_ave', 'EPSCs_all')